/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;

public class MainCanvas
extends Canvas
implements CommandListener,
Runnable {
    Resource res = Resource.getInstance();
    View view = View.getInstance();
    AI ai = AI.getInstance();
    MapLoader loader = new MapLoader();

    public MainCanvas() {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        RMSMgr rMSMgr = RMSMgr.getInstance();
        byte[] byArray = new byte[1];
        for (int i = 0; i < this.res.level_open.length; ++i) {
            byArray = rMSMgr.getRmsByte("level_" + i);
            if (byArray == null) continue;
            this.res.level_open[i] = byArray[0] == 1;
        }
        this.setFullScreenMode(true);
        Key.mapGameKey((byte)1, (byte)6, (byte)2, (byte)5, (byte)-6, (byte)-7, (byte)8, (byte)42);
        byte[] byArray2 = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57};
        Key.mapNumberKey(byArray2);
        this.res.init();
        this.view.initGameScreen1();
        this.res.game_state = (byte)14;
        this.res.addSound("knock");
        this.res.addSound("bomb");
        this.res.addSound("kill");
        this.res.addMidi("item");
        this.res.addMidi("open");
        this.res.addMidi("tip");
        this.res.addMidi("title", -1);
        this.res.setDefaultCamera();
    }

    public void hideNotify() {
        if (Resource.getInstance().game_state == 0) {
            View.getInstance().initGamePause();
            Resource.getInstance().game_state = (byte)5;
        }
        this.res.stopSound("title");
    }

    public void showNotify() {
        switch (Resource.getInstance().game_state) {
            case 0: {
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 19: {
                if (this.res.game_config_back != 0) break;
                this.res.stopSound("title");
                this.res.playSound("title");
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                this.res.stopSound("title");
                this.res.playSound("title");
            }
        }
    }

    protected void keyReleased(int n) {
        Key.keyRelease(n);
        Key.keyRelease(this.getGameAction(n));
    }

    protected void keyPressed(int n) {
        Key.keyPressed(n);
        Key.keyPressed(this.getGameAction(n));
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command.getCommandType() == 7) {
            MainMIDlet.quitApp();
        }
    }

    protected void paint(Graphics graphics) {
        this.ai.update();
        this.view.paint(graphics);
    }

    public void run() {
        while (true) {
            try {
                while (true) {
                    this.repaint();
                    Thread.sleep(80L);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                continue;
            }
            break;
        }
    }
}

